<?php
namespace App\Http\Controllers;

use App\Models\PaymentSetting;
use App\Models\Plan;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class MembershipController extends Controller
{
    public function index()
    {
        $theme          = getTheme();
        $title          = __('frontend-labels.membership.title');
        $paymentSetting = PaymentSetting::where('status', true)->first();
        $currency       = $paymentSetting->currency_symbol ?? '$';

        $user_data = $user = Auth::user();

        // Eager load the relationships to avoid N+1 query issues
        $membership_data = Plan::with(['features_plan', 'planTenures' => function ($query) {
            $query->orderBy('price', 'asc');
        }])
            ->where('status', 1)
            ->get();

        $data = [
            'theme'           => $theme,
            'title'           => $title,
            'membership_data' => $membership_data,
            'currency'        => $currency,
            'user'            => $user_data,
            'payment'         => $paymentSetting,
        ];
        return view("front_end/{$theme}/pages/membership_plan", $data);
    }
}
